package.path = "./app/lib/?.lua;" .. package.path
require("ucs2")

-----------------------------------------------------------------------
local function load(lession_file, luid, maxccp)
	
	-------------------------------------------------------------
	local self = {}
	
	self.exem  		= {}
	self.exem2  		= {}		-- py1 wb1 汉字
	self.exem3  		= {}		-- py1 拼音
	self.input 		= {L""}
	self.plc 		= {0}
	self.luid       = luid
	self.less_file	= lession_file
	self.accuracy   = {}
	self.isPY1 = (self.luid == 'py1')
	self.isWB1 = ( (self.luid == 'wb1') or (self.luid == 'wb1_98') )
	self.isEn1 = (self.luid == 'en1')
	self.wrongWords = {}
	self.wrongWords2 = {}
	self.wrongWords3 = {}
	self.wrongWordsCount = {0}
	self.lastLen = 0
	
	-------------------------------------------------------------
	
	local function update_accu(less, index)
		if index > #less.input then
			return L""
		end
		
		local stat = {}
		
		local input = self.input
		local exem  = self.exem
		local exem2 = self.exem2
		local exem3 = self.exem3
		
		local count_same = 0
		local count_diff = 0
		local len = ucs2.len(input[index])
		local i = 1
	
			
		for i = 1, len do
			if ucs2.sub(input[index], i, i) == ucs2.sub(exem[index], i, i) then
				table.insert(stat, "s")
				count_same = count_same + 1
--				if self.isEn1 then
				if (self.lastLen < len) and (i == len) and (self.isWB1 == false) then
					PlayErrSound('conf/type.wav')
				end				
			else
				count_diff = count_diff + 1
				table.insert(stat, "d")
--				if self.isEn1 then
				if (self.lastLen < len) and (i == len) and (self.isWB1 == false) then
					PlayErrSound('conf/Error.wav')
				end
				if i == len then
					table.insert(self.wrongWords, ucs2.sub(exem[index], i, i))
					if table.getn(exem2) > 0 then
						table.insert(self.wrongWords2, ucs2.sub(exem2[index], i, i))
					end
					if table.getn(exem3) > 0 then
						table.insert(self.wrongWords3, ucs2.sub(exem3[index], i, i))
					end
				end
			end
		end
		
		self.lastLen = len
		
		local item = {}
		item.diff = u2w(table.concat(stat))
		local len = ucs2.len(item.diff)
		
		local accu = less.accuracy
		
		local loc   = index - 1
		local allWord = 0
		local wrongCount = 0
		if loc > 0 then
			wrongCount = self.wrongWordsCount[loc]
			if wrongCount > 0 then
				allWord = wrongCount / (1 - accu[loc].accu)
			else
				allWord = self.plc[loc + 1]
			end
		end
		wrongCount = table.getn(self.wrongWords) - wrongCount
		allWord = allWord + wrongCount + count_same

		if allWord > 0 then
			item.accu = (allWord - table.getn(self.wrongWords)) / allWord
		else
			item.accu = 0
		end
		
		accu[index] = item
	end
	
	-------------------------------------------------------------
	self.se = function (self, index)
		if index > #self.exem then
			return L""
		end
		return self.exem[index]
	end
	self.se2 = function (self, index)
		if index > #self.exem2 then
			return L""
		end
		return self.exem2[index]
	end
	self.se3 = function (self, index)
		if index > #self.exem3 then
			return L""
		end
		return self.exem3[index]
	end

	self.si = function (self, index)
		if index > #self.input then
			return L""
		end
		return self.input[index]
	end

	self.len = function (self, index)
		if index > #self.exem then
			return 0
		end
		return self.plc[index+1] - self.plc[index]
	end
	
	self.input_maxcp = function (self)
		local loc = self:locate()
        return self.plc[loc] + ucs2.len(self:si(loc))
	end
	
	self.locate = function (self)
		return #self.input
	end
	
	self.push_back = function (self, text)
		local loc   = self:locate()
		local input = self.input
		local exem  = self.exem
		
		input[loc] = ucs2.sub(text, 1, self:len(loc))
		update_accu(self, loc)
		if #input[loc] == #exem[loc] and #input < #exem then
			if self.isEn1 or self.isWB1 then
				local len = ucs2.len(text)
				if ucs2.sub(input[loc], len, len) == ucs2.sub(exem[loc], len, len) then
				else
					local textNew = ucs2.sub(text, 1, len - 1)
					return self:push_back(textNew)
				end
			else
			end
			self.wrongWordsCount[loc] = table.getn(self.wrongWords);
			table.insert(input, L"")
			update_accu(self, loc+1)
			if ucs2.len(text) <= self:len(loc) then
				return true
			else
				local len = ucs2.len(text)
				local textNew = ucs2.sub(text, self:len(loc)+1, len)
				return self:push_back(textNew)
			end
		end
		return false
	end

	self.pop_back = function (self)
		local loc   = self:locate()
		local input = self.input
		local exem  = self.exem
		
		if loc == 1 and #input[1] == 0 then
			return false
		end
		
		if #input[loc] == 0 then
			table.remove(input)
			loc = self:locate()
			if #input[loc] == 0 then
				return false
			end
		end
		
		input[loc] = ucs2.sub(input[loc], 1, -2)
		update_accu(self, loc)
		
		return true
	end
	
	self.diff = function (self, index)
		local loc = self:locate()
		if index > loc then
			return L""
		end
		return self.accuracy[index].diff
	end

	self.accu = function (self, index)
		local loc = self:locate()
		return self.accuracy[loc].accu
	end
	
	self.progress = function (self)
		local len = #self.plc
 		return self:input_maxcp() / (self.plc[len])
	end
		
	self.nextch = function(self)
		local loc = self:locate()
		local input = self:si(loc)
		local exem  = self:se(loc)
		
		local len = ucs2.len(input)
		return ucs2.sub(exem, len+1, len+1)
	end

	self.seek = function (self, cp)
		local maxcp = cp or self.input_maxcp()
		local len = #self.plc
		local i = 1 
		for i = 1, len do
			if maxcp > self.plc[i] then
				return {loc=i, offest = maxcp - self.plc[i]}
			end
		end
		return {loc=0, offset=0}
    end
	
	self.saveWrongWords = function (self, path)
		if ucs2.len(self.wrongWords) > 0 then
			local fout = io.open(path, "a+")
			local isWB1 = self.isWB1
			if isWB1 then
				fout:write(w2u(table.concat(self.wrongWords)))
				fout:write('\n')
				fout:write(w2u(table.concat(self.wrongWords2)))
				fout:write('\n')
				fout:write(w2u(table.concat(self.wrongWords3)))
				fout:write('\n')
			else
				fout:write(w2u(table.concat(self.wrongWords)))
			end
			fout:close()
		end
	end
	

	-------------------------------------------------------------
	local maxcp = 0

	local isPY1 = self.isPY1
	local isWB1 = self.isWB1
	
	local line = ""
	local nLine = 0
	for line in io.lines(lession_file .. ".le") do
		line = u2w(line)
		local len = ucs2.len(line)
		
		local i = 0
		for i = 1, len, maxccp do
			local text = ucs2.sub(line, i, i+maxccp-1)
			if isPY1 or isWB1 then
				if nLine == 0 then
					table.insert(self.exem, text)
					maxcp = maxcp + ucs2.len(text)
					table.insert(self.plc, maxcp)
					update_accu(self, i)
				else
					if nLine == 1 then
						table.insert(self.exem2, text)
					else
						table.insert(self.exem3, text)
					end
				end
			else		
				table.insert(self.exem, text)
				maxcp = maxcp + ucs2.len(text)
				table.insert(self.plc, maxcp)
				update_accu(self, i)
			end		
		end
		nLine = (nLine + 1) % 3
	end
	
	return self
end

-----------------------------------------------------------------------
return {load=load}
